/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.durabilitytooltip;

import com.supermartijn642.durabilitytooltip.DurabilityTooltipConfig;
import com.supermartijn642.durabilitytooltip.TooltipColorStyle;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public enum TooltipStyle {
    BAR,
    NUMBERS,
    TEXT;


    public void appendTooltip(List<Component> tooltips, int durability, int maxDurability) {
        boolean showTooltipHint = DurabilityTooltipConfig.showTooltipHint.get();
        ChatFormatting baseColor = DurabilityTooltipConfig.baseTooltipColor.get();
        TooltipColorStyle colorStyle = DurabilityTooltipConfig.tooltipColorStyle.get();
        ChatFormatting reactiveColor = colorStyle.getColorForDurability(baseColor, durability, maxDurability);
        switch (this) {
            case BAR: {
                if (showTooltipHint) {
                    tooltips.add((Component)new TranslatableComponent("durabilitytooltip.info.bar.durability_hint").m_130940_(baseColor));
                }
                int fullCharacters = Math.round(10.0f * (float)durability / (float)maxDurability);
                TextComponent innerBar = new TextComponent("");
                for (int character = 0; character < 10; ++character) {
                    innerBar.m_7220_((Component)new TranslatableComponent(character < fullCharacters ? "durabilitytooltip.info.bar.full_symbol" : "durabilitytooltip.info.bar.empty_symbol").m_130940_(reactiveColor));
                }
                MutableComponent bar = new TranslatableComponent("durabilitytooltip.info.bar.bar_line", new Object[]{innerBar}).m_130940_(baseColor);
                tooltips.add((Component)bar);
                break;
            }
            case NUMBERS: {
                MutableComponent durabilityComponent = new TextComponent(Integer.toString(durability)).m_130940_(reactiveColor);
                MutableComponent maxDurabilityComponent = new TextComponent(Integer.toString(maxDurability)).m_130940_(colorStyle == TooltipColorStyle.VARYING ? baseColor : reactiveColor);
                MutableComponent numbers = durability == maxDurability ? new TranslatableComponent("durabilitytooltip.info.numbers.full_durability", new Object[]{maxDurabilityComponent}).m_130940_(baseColor) : new TranslatableComponent("durabilitytooltip.info.numbers.damaged", new Object[]{durabilityComponent, maxDurabilityComponent}).m_130940_(baseColor);
                if (showTooltipHint) {
                    numbers = new TranslatableComponent("durabilitytooltip.info.numbers.durability_hint", new Object[]{numbers}).m_130940_(baseColor);
                }
                tooltips.add((Component)numbers);
                break;
            }
            case TEXT: {
                String translationKey = durability == maxDurability ? "durabilitytooltip.info.text.full_durability" : ((float)durability >= 0.4f * (float)maxDurability ? "durabilitytooltip.info.text.damaged" : ((float)durability >= 0.1f * (float)maxDurability ? "durabilitytooltip.info.text.severely_damaged" : "durabilitytooltip.info.text.nearly_broken"));
                MutableComponent tooltip = new TranslatableComponent(translationKey).m_130940_(reactiveColor);
                if (showTooltipHint) {
                    tooltip = new TranslatableComponent("durabilitytooltip.info.text.durability_hint", new Object[]{tooltip}).m_130940_(baseColor);
                }
                tooltips.add((Component)tooltip);
            }
        }
    }
}

